--> pralable
-- USE BD_Air_France;

-- Analytiques

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), qlf_hvol  DECIMAL(5,2));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320',200.50);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330',300);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340',158.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330',456);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340',251);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380',169.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330',450.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340',148);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320',500.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340',120);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320',780);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320',520.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320',600.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330',100.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330',150);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340',200.60);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380',290);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2007,'A380',90);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'A380',800);
INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'B777',200);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2011,'A380',900);

-- OVER

-- avec des fct agrgats

SELECT avi_typavi,qlf_annee,qlf_brevet
    ,SUM(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee) AS "Total h"
    ,AVG(qlf_hvol)     OVER(PARTITION BY qlf_annee)  AS "Moyenne anne"
    ,AVG(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee)  AS "Moyenne anne/avion"
	,COUNT(qlf_brevet) OVER(PARTITION BY avi_typavi,qlf_annee) AS "Pilotes"
    ,MIN(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Min"
    ,MAX(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Max"
FROM T_qualifs_qlf;

-- Ranking 

SELECT ROW_NUMBER() 
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "ROW_NUMBER()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf;

SELECT RANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "RANK()",
      qlf_brevet,avi_typavi,qlf_annee
FROM  T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT DENSERANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "DENSERANK()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT NTILE(4) 
      OVER(ORDER BY avi_typavi,qlf_hvol DESC) AS "NTILE",
     qlf_brevet,avi_typavi,qlf_hvol,qlf_annee
FROM T_qualifs_qlf;

SELECT TOP(3) WITH TIES
 RANK() OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS rang,
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
ORDER BY rang;

-- analytiques

-- Valeur suivante dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LEAD (qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+1",
       LEAD (qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+2"
FROM   T_qualifs_qlf;


-- Valeur prcdente dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LAG(qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-1",
       LAG(qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-2"
FROM   T_qualifs_qlf;

-- Premire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     FIRST_VALUE(qlf_annee) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Anne +faible",
     FIRST_VALUE(qlf_hvol) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Heure vol"
FROM   T_qualifs_qlf;

-- dernire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     LAST_VALUE(qlf_annee)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol 
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Anne +forte",
     LAST_VALUE(qlf_hvol)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Heure vol"
FROM   T_qualifs_qlf;

-- Partie de cumul de dataset

SELECT 
     qlf_brevet,avi_typavi,qlf_annee,qlf_hvol,
     CUME_DIST() OVER(PARTITION BY avi_typavi ORDER BY qlf_hvol) AS "CUME_DIST"
FROM   T_qualifs_qlf
ORDER BY 5 DESC;
